package com.opo.oposcalesyncsdkdemo;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.os.Environment;
import android.telephony.mbms.FileInfo;
import android.util.Log;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

import OnePlusOneAndroidSDK.ScaleSync.Action;
import OnePlusOneAndroidSDK.ScaleSync.DataType;
import OnePlusOneAndroidSDK.ScaleSync.SDKDeviceInfo;
import OnePlusOneAndroidSDK.ScaleSync.SyncSDK;
import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import com.opo.oposcalesyncsdkdemo.PLUFileClass;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "MainActivity";
    public SyncSDK mSyncSDK;

    @BindView(R.id.et_addr) TextView et_addr;
    @BindView(R.id.scaleWeight) TextView scaleWeight;
    @BindView(R.id.pb_onprocess) ProgressBar pb_onprocess;
    @BindView(R.id.textDevice) TextView textDevice;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        ButterKnife.bind(this);
        // mSyncSDK全局应当只有一个，且不需要释放。全局也只有一个ExecTaskProgressListener，通过UserDataFlag来判断消息是属于哪台机器的
         // There should be only one mSyncSDK globally and it doesn't need to be released. There's also only one ExecTaskProgressListener globally, using UserDataFlag to determine which machine the message belongs to
        mSyncSDK = SyncSDK.getInstance(new SyncSDK.ExecTaskProgressListener() {
            @Override
            public void OnProgressChanged(int nErrorCode, int Index, int Total, int UserDataFlag) {

                Log.d(TAG, "OnProgressChanged:  " + nErrorCode + " Index: " + Index +" Total: " + Total + "UserDataFlag: " + UserDataFlag);

                // 可以根据 UserDataFlag来判断是哪台机器的消息。//界面上显示进度
                 // Can determine which machine the message belongs to based on UserDataFlag   Show progress on UI
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        //
                        pb_onprocess.setMax(Total);
                        pb_onprocess.setProgress(Index);
                        //
                    }
                });
            }
        });
        //  不需要执行初始化
          // No initialization needed
    }

    public int ipToint(String sip) {
        int result = 0;
        String[] IP_list = sip.split("\\.");
        if (IP_list.length != 4)
        {
            return result;
        }
        int seg;
        for(int i = 0; i < IP_list.length; i++)
        {
            try{
                seg = Integer.parseInt(IP_list[i]);
            }
            catch (NumberFormatException e) {
                result = 0;
                return result;
            }
            if ((seg < 0) || (seg > 255)) {
                result = 0;
                return result;
            }
            if ((i == 3) && (seg == 0)) // 最后一位不为0   // The last digit should not be 0
            {
                result = 0;
                return result;
            }
            result = (seg << ((3 - i) * 8)) + result;
        }
        return result;
    }

    // assets 下的 plu.txt演示文件  // plu.txt demo file under assets
    private String CopyAssetsToSD(String sFile) {

        File outFile = new File(getExternalFilesDir(null), sFile);
        AssetManager assetManager = getAssets();
        try {
            InputStream in = assetManager.open(sFile);
            OutputStream out = new FileOutputStream(outFile);
            byte[] buffer = new byte[1024];
            int read;
            while((read = in.read(buffer)) != -1){
                out.write(buffer, 0, read);
            }
            in.close();
            in = null;
            out.flush();
            out.close();
            out = null;
        } catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return outFile.toString();
    }

    //
    // 获取设备信息 // Get device information
    @OnClick(R.id.btnGetDeviceInfo)
    public void devixesinfo_OnClick(){
        SDKDeviceInfo deviceInfo1 = new SDKDeviceInfo();
        int nHost = ipToint(et_addr.getText().toString());
        if (nHost == 0) {
            return;
        }
        if ( mSyncSDK.GetDevicesInfo(nHost,deviceInfo1) == 0){
            Log.d(TAG, "devixesinfo_OnClick: " + deviceInfo1.getAddr());
            Log.d(TAG, "devixesinfo_OnClick: " + deviceInfo1.getKeyID());
            Log.d(TAG, "devixesinfo_OnClick: byte len " + deviceInfo1.getDeviceNo().length);
            textDevice.setText("device version: " + deviceInfo1.getVersion());
        }
    }

//    // 获取网段设备信息
//    @OnClick(R.id.btn_GetNetworkSectionDevicesInfo)
//    public void GetNetworkSectionDevicesInfo_OnClick(){
//
//      int nHost =  mSyncSDK.MakeHostToDWord(et_addr.getText().toString());
//
//      SDKDeviceInfo[] deviceInfos = new SDKDeviceInfo[255];
//      for(int i = 0;i<deviceInfos.length;i++){
//            deviceInfos[i] = new SDKDeviceInfo();
//      }
//
//        int res = mSyncSDK.GetNetworkSectionDevicesInfo(nHost,deviceInfos);
//        if (res == 0)
//            Log.d(TAG, "GetNetworkSectionDevicesInfo_OnClick: null");
//        else {
//            for(int i=0;i<res;i++){
//                Log.d(TAG, "GetNetworkSectionDevicesInfo_OnClick: " + mSyncSDK.MakeDWordToHost(deviceInfos[i].Addr));
//            }
//        }
//
//    }

    // 读文本 // Read text
    public List<String> ReadTxt(String filePath) {
        //将读出来的一行行数据使用List存储  // Store the read lines in a List
        List newList=new ArrayList<String>();
        try {
            File file = new File(filePath);
            int count = 0;//初始化 key值   // Initialize key value
            if (file.isFile() && file.exists()) {//文件存在  // File exists
                InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
                BufferedReader br = new BufferedReader(isr);
                String lineTxt = null;
                while ((lineTxt = br.readLine()) != null) {
                    if (!"".equals(lineTxt)) {
                        String reds = lineTxt.split("\\+")[0];  //java 正则表达式    // java regular expression
                        newList.add(count, reds);
                        count++;
                    }
                }
                isr.close();
                br.close();
            }else {
                Toast.makeText(getApplicationContext(),"can not find file",0).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return newList;
    }

    @OnClick(R.id.btnPLUFile)
    public void WriteText_OnClick(){
        // 保存的文件路径     // File save path
        String sPath = getExternalFilesDir(null) + "/WritePLUFile.txt";

        String sPLUInfo1;
        String sPLUInfo2;
        // PLU信息  // PLU information
        PLUFileClass PLUInfo1 = new PLUFileClass();
        PLUFileClass PLUInfo2 = new PLUFileClass();
        // 字段      // Fields
        String sField;
// 这是字段, 文档的第一行, 和下面的内容相对应, 每一项都互相对应的, 使用一个\t进行隔开，其余的字段参考说明书
 // This is the field, the first line of the document, corresponding to the content below, each item corresponds to each other, separated by a \t, refer to the manual for other fields
        sField = "LFCode" + "\t" 
                + "ItemCode" + "\t"
                + "Department" + "\t"
                + "Name1" + "\t"
                + "Label1" + "\t"
                + "BarcodeType1" + "\t"
                + "UnitPrice" + "\t"
                + "WeightUnit" + "\t"
                + "ValidDays" + "\t"
                + "ProducedDateTime" + "\t"
                + "DiscountFlag" + "\t"
                + "DiscountUnitPrice" + "\t"
                + "DiscountStartDateTime" + "\t"
                + "DiscountEndDateTime" + "\t"
                ;

        PLUInfo1.LFCode = "10001";
        PLUInfo1.ItemCode = "10001";
        PLUInfo1.Department = "1";
        PLUInfo1.Label1 = "1";
        PLUInfo1.BarcodeType1 = "1";
        PLUInfo1.Name1 = "鱼丸_测试";
        PLUInfo1.UnitPrice = "15.5";
        PLUInfo1.WeightUnit = "0"; // 这里可以参看说明书的对照表 , 0表示Kg   // Refer to the manual's comparison table here, 0 represents Kg
        PLUInfo1.ValidDays = "10";
        // 由于安卓的默认日期格式比较复杂，因此，安卓的日期格式默认为：YYYY-MM-DD hh:mm:ss
        // Since Android's default date format is complex, the Android date format defaults to: YYYY-MM-DD hh:mm:ss
        PLUInfo1.ProducedDateTime = "2021-08-01 10:02:03";
        PLUInfo1.DiscountFlag = "1"; // 在2021-08-01到2099-08-01的日期里，每天的10:00:00到22:00:00时间段打折 // Discount period from 10:00:00 to 22:00:00 daily between 2021-08-01 to 2099-08-01
        PLUInfo1.DiscountUnitPrice = "10.5";
        PLUInfo1.DiscountStartDateTime = "2021-08-01 10:00:00";
        PLUInfo1.DiscountEndDateTime = "2099-08-01 22:00:00";

        PLUInfo2.LFCode = "10002";
        PLUInfo2.ItemCode = "10002";
        PLUInfo2.Department = "1";
        PLUInfo2.Label1 = "1";
        PLUInfo2.BarcodeType1 = "1";
        PLUInfo2.Name1 = "鸡翅_测试";
        PLUInfo2.UnitPrice = "25.5";
        PLUInfo2.WeightUnit = "0"; // 这里可以参看说明书的对照表 , 0表示Kg // Refer to the manual's comparison table here, 0 represents Kg
        PLUInfo2.ValidDays = "5";
        // 由于安卓的默认日期格式比较复杂，因此，安卓的日期格式默认为：YYYY-MM-DD hh:mm:ss
        // Since Android's default date format is complex, the Android date format defaults to: YYYY-MM-DD hh:mm:ss
        PLUInfo2.ProducedDateTime = "2021-08-01 10:02:03";
        PLUInfo2.DiscountFlag = "2"; // 在时间范围内，打折   // Discount within the time range
        PLUInfo2.DiscountUnitPrice = "15.5";
        PLUInfo2.DiscountStartDateTime = "2021-08-01 10:00:00";
        PLUInfo2.DiscountEndDateTime = "2099-08-01 22:00:00";

        sPLUInfo1 = PLUInfo1.LFCode + "\t" // 插入一个制表符       // Insert a tab
        + PLUInfo1.ItemCode + "\t"
        + PLUInfo1.Department + "\t"
        + PLUInfo1.Name1 + "\t"
        + PLUInfo1.Label1 + "\t"
        + PLUInfo1.BarcodeType1 + "\t"
        + PLUInfo1.UnitPrice + "\t"
        + PLUInfo1.WeightUnit + "\t"
        + PLUInfo1.ValidDays + "\t"
        + PLUInfo1.ProducedDateTime + "\t"
        + PLUInfo1.DiscountFlag + "\t"
        + PLUInfo1.DiscountUnitPrice + "\t"
        + PLUInfo1.DiscountStartDateTime + "\t"
        + PLUInfo1.DiscountEndDateTime + "\t"
        ;

        sPLUInfo2 = PLUInfo2.LFCode + "\t" // 插入一个制表符       // Insert a tab
        + PLUInfo2.ItemCode + "\t"
        + PLUInfo2.Department + "\t"
        + PLUInfo2.Name1 + "\t"
        + PLUInfo2.Label1 + "\t"
        + PLUInfo2.BarcodeType1 + "\t"
        + PLUInfo2.UnitPrice + "\t"
        + PLUInfo2.WeightUnit + "\t"
        + PLUInfo2.ValidDays + "\t"
        + PLUInfo2.ProducedDateTime + "\t"
        + PLUInfo2.DiscountFlag + "\t"
        + PLUInfo2.DiscountUnitPrice + "\t"
        + PLUInfo2.DiscountStartDateTime + "\t"
        + PLUInfo2.DiscountEndDateTime + "\t"
        ;

        try{
            File f = new File(sPath);
            byte[] b = new byte[3];
            b[0] = (byte)0xEF;
            b[1] = (byte)0xBB;
            b[2] = (byte)0xBF;
            if (f.isFile() && f.exists()){f.delete();}
            FileOutputStream osw = new FileOutputStream(f);
            osw.write(b);
            osw.write(sField.getBytes("utf-8"));
            osw.write("\r\n".getBytes("utf-8"));
            osw.write(sPLUInfo1.getBytes("utf-8"));
            osw.write("\r\n".getBytes("utf-8"));
            osw.write(sPLUInfo2.getBytes("utf-8"));
            osw.flush();
            osw.close();

        } catch (Exception e){
            e.printStackTrace();
        }
        Log.d(TAG, "写PLU文档完成");// PLU document writing completed


    }

    @OnClick(R.id.btnUpScaleWeight)
    public void ReadTxt_OnClick(){

        // 上传保存文件路径  // Upload save file path
        String sPath = getExternalFilesDir(null) + "/ScaleWeight.txt";
        int TaskID;

        //
        File file = new File(sPath);
        if (file.exists()){
            file.delete();
        }
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0          // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        TaskID = mSyncSDK.ExecTask(nHost, Action.UpLoad.getValue(),DataType.ScaleWeight.getValue(),sPath,0);
        if (TaskID != 0){
            mSyncSDK.WaitForTask(TaskID);
            Log.d(TAG, "DownPlu: 上载任务创建成功");       // Upload task created successfully

            List<String> txt = ReadTxt(sPath);
            if (txt.size()>1){
                Toast.makeText(this, txt.get(1), Toast.LENGTH_SHORT).show();
                scaleWeight.setText("重量: " + txt.get(1) + "g");  //weight
                Log.d(TAG, "ReadTxt_OnClick:  " + txt.get(1));
            }
        }
    }

    public void execDownPlu(int nHost, int action, int datatype, String sFile, int Userdata){
        new Thread(new Runnable() {
            @Override
            public void run() {
                if (mSyncSDK.ExecTask(nHost, action, datatype, sFile, Userdata) != 0) {
                    Log.d(TAG, "DownPlu: 下载任务创建成功"); // Download task created successfully
                }
            }
        }).start();
    }

    // 下载PLU    // Download PLU
    @OnClick(R.id.btn_DownPLU)
    public void DownPLU(){
        //下载文件路径    // Download file path
        String sPath = CopyAssetsToSD("plu.txt");
        Log.d(TAG, "DownPlu: " + sPath);

        // 下载 plu.txt 资料  // Download plu.txt data
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0   // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        execDownPlu(nHost, Action.DownLoad.getValue(), DataType.PLU.getValue(), sPath, nHost);

        int nHost2 = ipToint("10.2.2.248");
        execDownPlu(nHost2, Action.DownLoad.getValue(), DataType.PLU.getValue(), sPath, nHost2);
    }

    // 下载生成的PLU文档  // Download generated PLU document
    @OnClick(R.id.btnDownWritePLU)
    public void DownWritePLU(){
        //下载文件路径    // Download file path
        String sPath = getExternalFilesDir(null) + "/WritePLUFile.txt";
        Log.d(TAG, "DownWritePlu: " + sPath);

        // 下载 plu.txt 资料  // Download plu.txt data
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0   // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.DownLoad.getValue(),DataType.PLU.getValue(),sPath,0) != 0){
            Log.d(TAG, "DownWritePlu: 下载任务创建成功");  // Download task created successfully
        }
    }

    // 下载信息1  // Download information 1
    @OnClick(R.id.btnDownNote1)
    public void DownNote1(){
        // 下载文件路径   // Download file path
        String sPath = CopyAssetsToSD("note1.txt");
        Log.d(TAG, "DownNote1: " + sPath);

        // 下载note1.txt   // Download note1.txt
        int nHost = ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0          // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.DownLoad.getValue(),DataType.Note1.getValue(),sPath,0) != 0){
            Log.d(TAG, "DownNote1: 下载任务创建成功");
        }
    }

    // 下载信息2  // Download information 2
    @OnClick(R.id.btnDownNote2)
    public void DownNote2(){
        // 下载文件路径  // Download file path
        String sPath = CopyAssetsToSD("note2.txt");
        Log.d(TAG, "DownNote2: " + sPath);

        // 下载note2.txt   // Download note2.txt
        int nHost = ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.DownLoad.getValue(), DataType.Note2.getValue(), sPath,0) != 0){
            Log.d(TAG, "DownNote2: 下载任务创建成功");
        }
    }

    // 下载信息3  // Download information 3
    @OnClick(R.id.btnDownNote3)
    public void DownNote3(){
        // 下载文件路径   // Download file path
        String sPath = CopyAssetsToSD("note3.txt");
        Log.d(TAG, "DownNote3: " + sPath);

        // 下载note3.txt  // Download note3.txt
        int nHost = ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0  // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.DownLoad.getValue(), DataType.Note3.getValue(), sPath,0) != 0){
            Log.d(TAG, "DownNote3: 下载任务创建成功");   // Download task created successfully
        }
    }

    // 下载信息4  // Download information 4
    @OnClick(R.id.btnDownNote4)
    public void DownNote4(){
        // 下载文件路径 // Download file path
        String sPath = CopyAssetsToSD("note4.txt");
        Log.d(TAG, "DownNote4: " + sPath);

        // 下载note4.txt  // Download note4.txt
        int nHost = ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0 // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.DownLoad.getValue(), DataType.Note4.getValue(), sPath,0) != 0){
            Log.d(TAG, "DownNote3: 下载任务创建成功");  // Download task created successfully
        }
    }

    @OnClick(R.id.btn_UpPLU)
    public void UpPLU(){
        // 上传保存文件路径 // Upload save file path
        String sPath = getExternalFilesDir(null) + "upPLU.txt";
        //
        File file = new File(sPath);
        if (file.exists()){
            file.delete();
        }
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0 // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.UpLoad.getValue(),DataType.PLU.getValue(),sPath,0) != 0){
            Log.d(TAG, "UpPlu: 上载任务创建成功"); // Upload task created successfully
        }
    }

    @OnClick(R.id.btnUpLoadNote1)
    public void UpLoadNote1(){
        // 上传保存文件路径  // Upload save file path
        String sPath = getExternalFilesDir(null) + "upNote1.txt";
        //
        File file = new File(sPath);
        if (file.exists()){
            file.delete();
        }
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0  // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.UpLoad.getValue(), DataType.Note1.getValue(), sPath,0) != 0){
            Log.d(TAG, "UpNote1: 上载任务创建成功");
        }
    }

    @OnClick(R.id.btnUpLoadNote2)
    public void UpLoadNote2(){
        // 上传保存文件路径  // Upload save file path
        String sPath = getExternalFilesDir(null) + "upNote2.txt";
        //
        File file = new File(sPath);
        if (file.exists()){
            file.delete();
        }
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0 // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.UpLoad.getValue(), DataType.Note2.getValue(), sPath,0) != 0){
            Log.d(TAG, "UpNote2: 上载任务创建成功"); // Upload task created successfull
        }
    }

    @OnClick(R.id.btnUpLoadNote3)
    public void UpLoadNote3(){
        // 上传保存文件路径 // Upload save file path
        String sPath = getExternalFilesDir(null) + "upNote3.txt";
        //
        File file = new File(sPath);
        if (file.exists()){
            file.delete();
        }
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0 // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.UpLoad.getValue(), DataType.Note3.getValue(), sPath,0) != 0){
            Log.d(TAG, "UpNote3: 上载任务创建成功"); // Upload task created successfully
        }
    }

    @OnClick(R.id.btnUpLoadNote4)
    public void UpLoadNote4(){
        // 上传保存文件路径 // Upload save file path
        String sPath = getExternalFilesDir(null) + "upNote4.txt";
        //
        File file = new File(sPath);
        if (file.exists()){
            file.delete();
        }
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0  // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.UpLoad.getValue(), DataType.Note4.getValue(), sPath,0) != 0){
            Log.d(TAG, "UpNote4: 上载任务创建成功");
        }
    }

    @OnClick(R.id.btnDelPLU)
    public void DelPLU(){
        // 随便给个值 // Just give any value
        String sPath = "123";
        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0 // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.Delete.getValue(), DataType.PLU.getValue(), sPath,0) != 0){
            Log.d(TAG, "DelPLU: 删除任务创建成功");  // Delete task created successfully
        }
    }

    @OnClick(R.id.btnDelNote1)
    public void DelNote1(){
        // 随便给个值  // Just give any value
        String sPath = "123";

        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0 // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.Delete.getValue(), DataType.Note1.getValue(), sPath,0) != 0){
            Log.d(TAG, "DelNote1: 删除任务创建成功");// Delete task created successfully
        }
    }

    @OnClick(R.id.btnDelNote2)
    public void DelNote2(){
        // 随便给个值 // Just give any value
        String sPath = "123";

        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0 // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.Delete.getValue(), DataType.Note2.getValue(), sPath,0) != 0){
            Log.d(TAG, "DelNote2: 删除任务创建成功"); // Delete task created successfully
        }
    }

    @OnClick(R.id.btnDelNote3)
    public void DelNote3(){
        // 随便给个值 // Just give any value
        String sPath = "123";

        int nHost =  ipToint(et_addr.getText().toString());
        if (nHost == 0) // 如果是错误的IP地址，那nHost会等于0 // If it's an incorrect IP address, nHost will be 0
        {
            return;
        }
        if (mSyncSDK.ExecTask(nHost, Action.Delete.getValue(), DataType.Note3.getValue(), sPath,0) != 0){
            Log.d(TAG, "DelNote3: 删除任务创建成功"); // Delete task created successfully
        }
    }

    @Override
    protected void onDestroy() {
        //
        super.onDestroy();
    }
}
