unit Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, System.IOUtils,Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls,system.IniFiles;

type
  TfrmMain = class(TForm)
    
    btnSDK_Initialize: TButton;
    btnSDK_Finalize: TButton;      
    btnUpOnePLU: TButton;
    btnUpGroupPLU: TButton;       
    btnUpPLU: TButton;
    btnDownPLU: TButton;
    btnDelPLU: TButton;
    btnUpNote1: TButton;
    btnUpNote2: TButton;
    btnUpNote3: TButton;
    btnUpNote4: TButton;
    btnDownNote1: TButton;
    btnDownNote2: TButton;
    btnDownNote3: TButton;
    btnDownNote4: TButton;
    btnDelNote4: TButton;
    btnDelNote3: TButton;    
    btnDelNote2: TButton;  
    btnDelNote1: TButton;     
    btnUpSystemOptions: TButton;
    btnDownSystemOptions: TButton;    
    btnUpLabelFile: TButton;
    btnDownLabelFile: TButton;
    btnDownLabelBackGroudn: TButton;
    btnDownLabelFormat: TButton;    
    btnUpCustomBarcode: TButton; 
    btnDownCustomBarcode: TButton;
    btnUpHotkey: TButton;
    btnDownHotkey: TButton;        
    btnUpDepartment: TButton;
    btnDownDepartment: TButton;    
    btnDownTime: TButton;
    btnDownUnit: TButton;
    btnSetLanguage: TButton;      
    lblIP: TLabel;
    lblLanguage: TLabel;
    lblProgressBar: TLabel;

    lblTipUnit: TLabel;
    lblTipTime: TLabel;
    lblUserdataTestResult: TLabel;
    lblTipLabelFormat: TLabel;
    lblTipLabelBackGround: TLabel;
    ProgressBar: TProgressBar;
    edtIP: TEdit;
    edtLFCode: TEdit;
    cbb1: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure btnSDK_InitializeClick(Sender: TObject);
    procedure btnDownPLUClick(Sender: TObject);
    procedure btnDownDepartmentClick(Sender: TObject);
    procedure btnSDK_FinalizeClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnDownUnitClick(Sender: TObject);
    procedure btnDownHotkeyClick(Sender: TObject);
    procedure btnDownCustomBarcodeClick(Sender: TObject);
    procedure btnDownNote1Click(Sender: TObject);
    procedure btnDownNote2Click(Sender: TObject);
    procedure btnDownNote3Click(Sender: TObject);
    procedure btnDownNote4Click(Sender: TObject);
    procedure btnDownSystemOptionsClick(Sender: TObject);
    procedure btnDownTimeClick(Sender: TObject);
    procedure btnUpPLUClick(Sender: TObject);
    procedure btnUpDepartmentClick(Sender: TObject);
    procedure btnUpHotkeyClick(Sender: TObject);
    procedure btnUpCustomBarcodeClick(Sender: TObject);
    procedure btnUpNote1Click(Sender: TObject);
    procedure btnUpNote2Click(Sender: TObject);
    procedure btnUpNote3Click(Sender: TObject);
    procedure btnUpNote4Click(Sender: TObject);
    procedure btnUpSystemOptionsClick(Sender: TObject);
    procedure btnDelPLUClick(Sender: TObject);
    procedure btnDelNote1Click(Sender: TObject);
    procedure btnDelNote2Click(Sender: TObject);
    procedure btnDelNote3Click(Sender: TObject);
    procedure btnDelNote4Click(Sender: TObject);
    procedure btnDownLabelFormatClick(Sender: TObject);
    procedure btnDownLabelBackGroudnClick(Sender: TObject);
    procedure btnDownLabelFileClick(Sender: TObject);
    procedure btnUpLabelFileClick(Sender: TObject);
    procedure btnUpOnePLUClick(Sender: TObject);
    procedure btnUpGroupPLUClick(Sender: TObject);
    procedure btnSetLanguageClick(Sender: TObject);
  private
    { Private declarations }
    procedure LoadConfig;
    procedure LoadLanguage(LangCode : string);
  public
    { Public declarations }
    // ʱõ· Path used for downloading
    function GetDownFilePath: string;
    // ȡļ Get download file name
    function GetDownFileName(ADataType: Cardinal): string;
    // ϴõ· Path used for uploading
    function GetUpFilePath: string;
    // ȡϴļ Get upload file name
    function GetUpFileName(ADataType: Cardinal): string;
    //  Download data
    procedure DownFiles(ADataType: Cardinal);
    // ϴ Upload data
    procedure UpFiles(ADataType: Cardinal);
    // ɾ Delete data
    procedure DelFiles(ADataType: Cardinal);
  end;

var
  frmMain: TfrmMain;

implementation

uses SyncSDKDefine, SyncSDKIntf;

var
  ini_ConfigFilePath:string='';

{$R *.dfm}

procedure OnTaskProgress(nErrorCode, AIndex, ATotal: Cardinal; lpUserData: Pointer); stdcall;
begin
  TThread.Queue(nil,
    procedure
    begin
      case nErrorCode of
        SDK_Err_Success: // سɹ Download succeeded
          begin
            frmMain.lblUserdataTestResult.Caption := Integer(lpUserData).ToString;
          end;
        SDK_Err_Progress: // ؽ Download progress
          begin
            frmMain.ProgressBar.Max := ATotal;
            frmMain.ProgressBar.Position := AIndex;
          end;
        SDK_Err_Terminate: // ֶֹͣ Manually stopped
          begin

          end;

        // Ϣ Error messages
        SDK_Err_ProtocolTypeNotSupport: // ֵ֧Э Protocol type not supported
          begin

          end;
        SDK_Err_DataTypeNotSupport: // ֵ֧ Data type not supported
          begin

          end;
        SDK_Err_CannotOpenInputFile: // ޷ļ Unable to open input file
          begin

          end;
        SDK_Err_ImportDataFailed: // ֶƥ Field count does not match content count
          begin

          end;
        SDK_Err_CommDataFailed: // ͨѶ쳣 Communication data abnormal
          begin

          end;
        SDK_Err_ParseDataFailed: // 쳣 Data parsing failed
          begin

          end;
        SDK_Err_CannotCreateOutputFile: // ޷ļ Unable to create output file
          begin

          end;
        SDK_Err_CannotConnect: // ޷豸 Unable to connect to device
          begin

          end;

        SDK_Err_NotHaveThisCommand: // ûд No such command
          begin

          end;
        SDK_Err_DataOutOfRange: // ݳ Data out of range
          begin

          end;
        SDK_Err_WriteError: // дʧ Write failed
          begin

          end;
        SDK_Err_DiskNotEnough: // ʣռ䲻 Disk space not enough
          begin

          end;
        SDK_Err_ReadError: // ȡʧ Read failed
          begin

          end;
        SDK_Err_PackageNoError: // Ŵ Package number error
          begin

          end;
        SDK_Err_CommandError: //  Command error
          begin

          end;
        SDK_Err_DataError: // ݴ Data error
          begin

          end;
        SDK_Err_MissPaper: // ȱֽ Paper missing
          begin

          end;
        SDK_Err_MD5CheckError: // MD5Уʧ MD5 check failed
          begin

          end;

        SDK_Err_ErrorPackageLenError: // ӦݳȲ1 Error package length is not 1
          begin

          end;
        SDK_Err_PackageLenError: // ӦݳȲ Package length error
          begin

          end;
        SDK_Err_NoThisErrorCode: // ûд˴ No such error code
          begin

          end;
          SDK_Err_DataErrNotErrCode: // ݴ, ҲǴ Data error, and not an error code
          begin

          end;
      end;
    end);
end;

function MakeHostToDWord(sHost: string): Cardinal;
var
  I: Integer;
  Segment: TArray<string>;
begin
  Result := 0;
  Segment := sHost.Split(['.']);
  if Length(Segment) <> 4 then
    Exit;
  for I := 0 to Length(Segment) - 1 do
  begin
    if StrToIntDef(Segment[I], -1) in [0 .. 255] then
      Result := Result + Cardinal(StrToInt(Segment[I]) shl ((3 - I) * 8))
    else
      Exit(0);
  end;
end;

procedure TfrmMain.btnDelNote1Click(Sender: TObject);
begin
  DelFiles(Sync_DataType_Note1);
end;

procedure TfrmMain.btnDelNote2Click(Sender: TObject);
begin
  DelFiles(Sync_DataType_Note2);
end;

procedure TfrmMain.btnDelNote3Click(Sender: TObject);
begin
  DelFiles(Sync_DataType_Note3);
end;

procedure TfrmMain.btnDelNote4Click(Sender: TObject);
begin
  DelFiles(Sync_DataType_Note4);
end;

procedure TfrmMain.btnDelPLUClick(Sender: TObject);
begin
  DelFiles(Sync_DataType_PLU);
end;

procedure TfrmMain.btnDownCustomBarcodeClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_CustomBarcode);
end;

procedure TfrmMain.btnDownDepartmentClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_Department);
end;

procedure TfrmMain.btnDownHotkeyClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_Hotkey);
end;

procedure TfrmMain.btnDownLabelBackGroudnClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_LabelBackGround);
end;

procedure TfrmMain.btnDownLabelFileClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_LabelFile);
end;

procedure TfrmMain.btnDownLabelFormatClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_Label);
end;

procedure TfrmMain.btnDownNote1Click(Sender: TObject);
begin
  DownFiles(Sync_DataType_Note1);
end;

procedure TfrmMain.btnDownNote2Click(Sender: TObject);
begin
  DownFiles(Sync_DataType_Note2);
end;

procedure TfrmMain.btnDownNote3Click(Sender: TObject);
begin
  DownFiles(Sync_DataType_Note3);
end;

procedure TfrmMain.btnDownNote4Click(Sender: TObject);
begin
  DownFiles(Sync_DataType_Note4);
end;

procedure TfrmMain.btnDownPLUClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_PLU);
end;

procedure TfrmMain.btnDownSystemOptionsClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_SystemOptions);
end;

procedure TfrmMain.btnDownTimeClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_Time);
end;

procedure TfrmMain.btnDownUnitClick(Sender: TObject);
begin
  DownFiles(Sync_DataType_Unit);
end;

procedure TfrmMain.btnSDK_FinalizeClick(Sender: TObject);
begin
  SDK_Finalize;
end;

procedure TfrmMain.btnSDK_InitializeClick(Sender: TObject);
begin
  SDK_Initialize;
end;

procedure TfrmMain.btnSetLanguageClick(Sender: TObject);
var
   ini_Config : TIniFile;
begin
   if(not TFile.Exists(ini_ConfigFilePath))then
   begin
      exit;
   end;
   ini_Config := TIniFile.Create(ini_ConfigFilePath);
   try
     ini_Config.WriteString('Config','LangCode',cbb1.Text);
     LoadLanguage(cbb1.Text);
   finally
     ini_Config.Free;
   end;
end;

procedure TfrmMain.btnUpCustomBarcodeClick(Sender: TObject);
begin
  UpFiles(Sync_DataType_CustomBarcode);
end;

procedure TfrmMain.btnUpDepartmentClick(Sender: TObject);
begin
  UpFiles(Sync_DataType_Department);
end;

procedure TfrmMain.btnUpGroupPLUClick(Sender: TObject);
var
  sIP: string;
  iAddr: Cardinal;
  DeviceInfo: TSDKDeviceInfo;
  iLFCode: Integer;
  InFileName, OutFileName: string;
begin
  sIP := edtIP.Text;
  iAddr := MakeHostToDWord(sIP); // IPַתΪ Convert IP address to number
  if iAddr = 0 then
  begin
    ShowMessage('The IP address is incorrect');
    exit;
  end;

  // ȼ豸Ƿ Check if the device is online first
  DeviceInfo := SDK_GetDeviceInfo(iAddr);

  if DeviceInfo.ProtocolType = SDK_ProtocolType_None then
  begin
    ShowMessage('Device not found');
    exit;
  end;

  OutFileName := GetUpFilePath + 'PLU' + FormatDateTime('_YYYY_MM_DD_HH_NN_SS', Now) + '.txt';
  ForceDirectories(ExtractFileDir(OutFileName));

  iLFCode := StrToIntDef(edtLFCode.Text, 0);
  if iLFCode = 0 then
    Exit;

  InFileName := ExtractFilePath(Application.ExeName) + 'InFileName.txt';
  SDK_GetGroupPLU(DeviceInfo.Addr, PWideChar(InFileName), PWideChar(OutFileName));
end;
procedure TfrmMain.btnUpHotkeyClick(Sender: TObject);
begin
  UpFiles(Sync_DataType_Hotkey);
end;

procedure TfrmMain.btnUpLabelFileClick(Sender: TObject);
begin
  UpFiles(Sync_DataType_LabelFile);
end;

procedure TfrmMain.btnUpNote1Click(Sender: TObject);
begin
  UpFiles(Sync_DataType_Note1);
end;

procedure TfrmMain.btnUpNote2Click(Sender: TObject);
begin
  UpFiles(Sync_DataType_Note2);
end;

procedure TfrmMain.btnUpNote3Click(Sender: TObject);
begin
  UpFiles(Sync_DataType_Note3);
end;

procedure TfrmMain.btnUpNote4Click(Sender: TObject);
begin
  UpFiles(Sync_DataType_Note4);
end;

procedure TfrmMain.btnUpOnePLUClick(Sender: TObject);
var
  sIP: string;
  iAddr: Cardinal;
  DeviceInfo: TSDKDeviceInfo;
  iLFCode: Integer;
  FileName: string;
begin
  sIP := edtIP.Text;
  iAddr := MakeHostToDWord(sIP); // IPַתΪ Convert IP address to number
  if iAddr = 0 then
  begin
    ShowMessage('The IP address is incorrect');
    exit;
  end;

  // ȼ豸Ƿ Check if the device is online first
  DeviceInfo := SDK_GetDeviceInfo(iAddr);

  if DeviceInfo.ProtocolType = SDK_ProtocolType_None then
  begin
    ShowMessage('Device not found');
    exit;
  end;

  FileName := GetUpFilePath + 'PLU' + FormatDateTime('_YYYY_MM_DD_HH_NN_SS', Now) + '.txt';;
  ForceDirectories(ExtractFileDir(FileName));

  iLFCode := StrToIntDef(edtLFCode.Text, 0);
  if iLFCode = 0 then
    Exit;
  SDK_GetOnePLU(DeviceInfo.Addr, iLFCode, PWideChar(FileName));

end;

procedure TfrmMain.btnUpPLUClick(Sender: TObject);
begin
  UpFiles(Sync_DataType_PLU);
end;

procedure TfrmMain.btnUpSystemOptionsClick(Sender: TObject);
begin
  UpFiles(Sync_DataType_SystemOptions);
end;

procedure TfrmMain.DownFiles(ADataType: Cardinal);
var
  sIP: string;
  iAddr: Cardinal;
  DeviceInfo: TSDKDeviceInfo;
  iUserDataTest: integer;
begin
  sIP := edtIP.Text;
  iAddr := MakeHostToDWord(sIP); // IPַתΪ Convert IP address to number
  if iAddr = 0 then
  begin
    ShowMessage('The IP address is incorrect');
    exit;
  end;

  // ȼ豸Ƿ Check if the device is online first
  DeviceInfo := SDK_GetDeviceInfo(iAddr);

  if DeviceInfo.ProtocolType = SDK_ProtocolType_None then
  begin
    ShowMessage('Device not found');
    exit;
  end;

  iUserDataTest := 1234;

// 첽    עʱʹòΪ: Sync_Action_DownLoad // Asynchronous download, note that when downloading, use the parameter: Sync_Action_DownLoad
  SDK_ExecTask(DeviceInfo.Addr, Sync_Action_DownLoad, ADataType,
    PWideChar(GetDownFileName(ADataType)), OnTaskProgress, Pointer(iUserDataTest));

  // ͬģʽ  ִSDK_ExecTaskᴴ̣߳  SDK_WaitForTask ȴ߳˳ // Synchronous mode, executing SDK_ExecTask creates a thread, while SDK_WaitForTask waits for the thread to exit
//  SDK_WaitForTask(SDK_ExecTask(DeviceInfo.Addr, Sync_Action_DownLoad, ADataType,
//    GetDownFileName(ADataType), OnTaskProgress, Pointer(iUserDataTest)));
end;

procedure TfrmMain.UpFiles(ADataType: Cardinal);
var
  sIP: string;
  iAddr: Cardinal;
  DeviceInfo: TSDKDeviceInfo;
  iUserDataTest: integer;
begin
  sIP := edtIP.Text;
  iAddr := MakeHostToDWord(sIP); // IPַתΪ // Convert IP address to number
  if iAddr = 0 then
  begin
    ShowMessage('The IP address is incorrect');
    exit;
  end;

  // ȼ豸Ƿ // Check if the device is online first
  DeviceInfo := SDK_GetDeviceInfo(iAddr);

  if DeviceInfo.ProtocolType = SDK_ProtocolType_None then
  begin
    ShowMessage('Device not found');
    exit;
  end;

  iUserDataTest := 1234;

  ForceDirectories(ExtractFileDir(GetUpFileName(ADataType)));

  // עϴʱʹòΪ: Sync_Action_UpLoad // Note that when uploading, use the parameter: Sync_Action_UpLoad
  SDK_ExecTask(DeviceInfo.Addr, Sync_Action_UpLoad, ADataType,
    PWideChar(GetUpFileName(ADataType)), OnTaskProgress, Pointer(iUserDataTest));

  // ͬģʽ  ִSDK_ExecTaskᴴ̣߳  SDK_WaitForTask ȴ߳˳ // Synchronous mode, executing SDK_ExecTask creates a thread, while SDK_WaitForTask waits for the thread to exit
//  SDK_WaitForTask(SDK_ExecTask(DeviceInfo.Addr, Sync_Action_UpLoad, ADataType,
//    GetDownFileName(ADataType), OnTaskProgress, Pointer(iUserDataTest)));
end;

procedure TfrmMain.DelFiles(ADataType: Cardinal);
var
  sIP: string;
  iAddr: Cardinal;
  DeviceInfo: TSDKDeviceInfo;
  iUserDataTest: integer;
begin
  sIP := edtIP.Text;
  iAddr := MakeHostToDWord(sIP); // IPַתΪ // Convert IP address to number
  if iAddr = 0 then
  begin
    ShowMessage('The IP address is incorrect');
    exit;
  end;

  // ȼ豸Ƿ // Check if the device is online first
  DeviceInfo := SDK_GetDeviceInfo(iAddr);

  if DeviceInfo.ProtocolType = SDK_ProtocolType_None then
  begin
    ShowMessage('Device not found');
    exit;
  end;

  iUserDataTest := 1234;

  // עɾʱʹòΪ: Sync_Action_Delete // Note that when deleting, use the parameter: Sync_Action_Delete
  SDK_ExecTask(DeviceInfo.Addr, Sync_Action_Delete, ADataType,
    PWideChar(GetDownFileName(ADataType)), OnTaskProgress, Pointer(iUserDataTest));

  // ͬģʽ  ִSDK_ExecTaskᴴ̣߳  SDK_WaitForTask ȴ߳˳ // Synchronous mode, executing SDK_ExecTask creates a thread, while SDK_WaitForTask waits for the thread to exit
//  SDK_WaitForTask(SDK_ExecTask(DeviceInfo.Addr, Sync_Action_Delete, ADataType,
//    GetDownFileName(ADataType), OnTaskProgress, Pointer(iUserDataTest)));
end;

procedure ReadAllValuesInSection(IniFile : TIniFile; const ASection: string; var values: TStringList);
var
  Keys: TStringList;
  i:integer;
begin
  if (not assigned(values))  or (not assigned(IniFile)) then
  begin
     exit;
  end;
  try

    Keys := TStringList.Create;
    try
      IniFile.ReadSection(ASection, Keys);
      for  i:= 0 to Keys.Count - 1 do
      begin
        // Add only the value of each key to the result string list
        values.Add(IniFile.ReadString(ASection, Keys[i], ''));
      end;
    finally
      Keys.Free;
    end;

  except
    on E: Exception do
      Writeln('Error reading INI file: ', E.Message);
  end;
end;


procedure TfrmMain.LoadLanguage(LangCode : string);
var
  ini_LangFilePath : string;
  ini_Lang :TIniFile;
  controllerStrings : TStringlist;
begin
    ini_LangFilePath := ExtractFilePath(Application.ExeName) + 'Language\' + LangCode + '.ini';
    
    if not Tfile.Exists(ini_LangFilePath)  then
    begin
       ini_LangFilePath := ExtractFilePath(Application.ExeName) + 'Language\' + 'English'+ '.ini';
       if not Tfile.Exists(ini_LangFilePath) then
       begin
         Exit;
       end;
    end;
    
    ini_Lang := TIniFile.Create(ini_LangFilePath);
    controllerStrings := TStringList.Create;
    try
        ReadAllValuesInSection(ini_Lang,'ControllerStrings',controllerStrings);
        if controllerStrings.Count < 37 then
        begin
          Exit;
        end;
        btnSDK_Initialize.Caption := controllerStrings.Strings[0];
        btnSDK_Finalize.Caption := controllerStrings.Strings[1];
        btnUpOnePLU.Caption := controllerStrings.Strings[2];
        btnUpGroupPLU.Caption := controllerStrings.Strings[3];
        btnUpPLU.Caption := controllerStrings.Strings[4];
        btnDownPLU.Caption := controllerStrings.Strings[5];
        btnDelPLU.Caption := controllerStrings.Strings[6];
        btnUpNote1.Caption := controllerStrings.Strings[7];
        btnUpNote2.Caption := controllerStrings.Strings[8];
        btnUpNote3.Caption := controllerStrings.Strings[9];
        btnUpNote4.Caption := controllerStrings.Strings[10];
        btnDownNote1.Caption := controllerStrings.Strings[11];
        btnDownNote2.Caption := controllerStrings.Strings[12];
        btnDownNote3.Caption := controllerStrings.Strings[13];
        btnDownNote4.Caption := controllerStrings.Strings[14];
        btnDelNote4.Caption := controllerStrings.Strings[18];
        btnDelNote3.Caption := controllerStrings.Strings[17];
        btnDelNote2.Caption := controllerStrings.Strings[16];
        btnDelNote1.Caption := controllerStrings.Strings[15];
        btnUpSystemOptions.Caption := controllerStrings.Strings[19];
        btnDownSystemOptions.Caption := controllerStrings.Strings[20];
        btnUpLabelFile.Caption := controllerStrings.Strings[21];
        btnDownLabelFile.Caption := controllerStrings.Strings[22];
        btnDownLabelBackGroudn.Caption := controllerStrings.Strings[23];
        btnDownLabelFormat.Caption := controllerStrings.Strings[24];
        btnUpCustomBarcode.Caption := controllerStrings.Strings[25];
        btnDownCustomBarcode.Caption := controllerStrings.Strings[26];
        btnUpHotkey.Caption := controllerStrings.Strings[27];
        btnDownHotkey.Caption := controllerStrings.Strings[28];
        btnUpDepartment.Caption := controllerStrings.Strings[29];
        btnDownDepartment.Caption := controllerStrings.Strings[30];
        btnDownTime.Caption := controllerStrings.Strings[31];
        btnDownUnit.Caption := controllerStrings.Strings[32];
        btnSetLanguage.Caption := controllerStrings.Strings[33];
        lblIP.Caption := controllerStrings.Strings[34];
        lblLanguage.Caption := controllerStrings.Strings[35];
        lblProgressBar.Caption := controllerStrings.Strings[36];
    finally
      ini_Lang.Free;
      controllerStrings.Free;
    end;
end;

procedure TfrmMain.LoadConfig;
var
  ini_Config : TIniFile;
  currentLanguage  : string;
  supportLanguages : TStringlist;
  Index:integer;
begin
  if(not TFile.Exists(ini_ConfigFilePath)) then
  begin
     exit;
  end;
  
  ini_Config := TIniFile.Create(ini_ConfigFilePath);
  supportLanguages := TStringList.Create;
  try
     currentLanguage:= ini_Config.ReadString('Config','LangCode','');

     LoadLanguage(currentLanguage);
     ReadAllValuesInSection(ini_Config,'SupportLanguages',supportLanguages);
     
     cbb1.Items.AddStrings(supportLanguages);
      Index := cbb1.Items.IndexOf(currentLanguage);
     if Index <> -1 then
     begin
      cbb1.ItemIndex := Index;
     end;   
  finally
     ini_Config.Free;
     supportLanguages.Free;
  end;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  btnSDK_InitializeClick(nil);
  LoadConfig();
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  btnSDK_FinalizeClick(nil);
end;

function TfrmMain.GetDownFileName(ADataType: Cardinal): string;
begin
  case ADataType of
    Sync_DataType_PLU: // Ʒ Single item information
      Result := GetDownFilePath + 'PLU.txt';
    Sync_DataType_Department: //  Department
      Result := GetDownFilePath + 'Department.txt';
    Sync_DataType_Unit: // λ Unit
      Result := GetDownFilePath + 'Unit.txt';
    Sync_DataType_Hotkey: // ȼ Hotkey
      Result := GetDownFilePath + 'Hotkey.txt';
    Sync_DataType_CustomBarcode: // Զ Custom barcode
      Result := GetDownFilePath + 'CustomBarcode.txt';
    Sync_DataType_Note1: // Ϣ1 Information 1
      Result := GetDownFilePath + 'Note1.txt';
    Sync_DataType_Note2: // Ϣ2 Information 2
      Result := GetDownFilePath + 'Note2.txt';
    Sync_DataType_Note3: // Ϣ3 Information 3
      Result := GetDownFilePath + 'Note3.txt';
    Sync_DataType_Note4: // Ϣ4 Information 4
      Result := GetDownFilePath + 'Note4.txt';
    Sync_DataType_SystemOptions:// ϵͳ System options
      Result := GetDownFilePath + 'SystemOptions.txt';
    Sync_DataType_Time: // ʱ Download time  // ʵ, ʱ䲻Ҫĵ, ڵĵ In fact, the download time does not require a document, just pass an existing file name
      Result := GetDownFilePath + 'PLU.txt';
    Sync_DataType_Label,
    Sync_DataType_LabelBackGround,
    Sync_DataType_LabelFile:
      Result := GetDownFilePath + 'DefaultLabel.lbl'; // Ĭϱǩļ Default label file
  end;
end;

function TfrmMain.GetDownFilePath: string;
begin
  Result := ExtractFilePath(Application.ExeName) + 'DownFiles\'; // ļ· Download file path
end;

function TfrmMain.GetUpFileName(ADataType: Cardinal): string;
begin
  case ADataType of
    Sync_DataType_PLU: // Ʒ Single item information
      Result := GetUpFilePath + 'PLU.txt';
    Sync_DataType_Department: //  Department
      Result := GetUpFilePath + 'Department.txt';
    Sync_DataType_Unit: // λ Unit
      Result := GetUpFilePath + 'Unit.txt';
    Sync_DataType_Hotkey: // ȼ Hotkey
      Result := GetUpFilePath + 'Hotkey.txt';
    Sync_DataType_CustomBarcode: // Զ Custom barcode
      Result := GetUpFilePath + 'CustomBarcode.txt';
    Sync_DataType_Note1: // Ϣ1 Information 1
      Result := GetUpFilePath + 'Note1.txt';
    Sync_DataType_Note2: // Ϣ2 Information 2
      Result := GetUpFilePath + 'Note2.txt';
    Sync_DataType_Note3: // Ϣ3 Information 3
      Result := GetUpFilePath + 'Note3.txt';
    Sync_DataType_Note4: // Ϣ4 Information 4
      Result := GetUpFilePath + 'Note4.txt';
    Sync_DataType_SystemOptions:// ϵͳ System options
      Result := GetUpFilePath + 'SystemOptions.txt';
    Sync_DataType_Time: // ʱ Download time  // ʵ, ʱ䲻Ҫĵ, ڵĵ In fact, the download time does not require a document, just pass an existing file name
      Result := GetUpFilePath + 'PLU.txt';
    Sync_DataType_LabelFile:
      Result := GetUpFilePath + '1.lbl'; // ϴ1űǩΪ 1.lbl  2űǩΪ2.lbl Upload label 1, named as 1.lbl, label 2 would be 2.lbl
  end;
end;

function TfrmMain.GetUpFilePath: string;
begin
  Result := ExtractFilePath(Application.ExeName) + 'UpFiles\';
end;

initialization
  ini_ConfigFilePath := ExtractFilePath(Application.ExeName) + '\Config\Config.ini';

end.
