unit SyncSDKDefine;

interface

{$IFDEF fpc}
{$MODE delphi}
{$ENDIF}

uses SysUtils;

const
  // Ͷ
  //    download
  Sync_Action_DownLoad = $0;
  // ϴ   upload
  Sync_Action_UpLoad = $1;
  // ɾ   delete
  Sync_Action_Delete = $2;
  //

  // ЭͶ   Protocol Type
  SDK_ProtocolType_None = 0;
  SDK_ProtocolType_Sttp = 1;

  // Ͷ   Data type define
  //                  //nil
  Sync_DataType_nil = $FFFF;
  // Ʒ               //Goods ,plu
  Sync_DataType_PLU = $0000;
  //               //Department
  Sync_DataType_Department = $0001;
  // λ              //unit of weight
  Sync_DataType_Unit = $0002;
  // ȼ             //Common product hotkeys
  Sync_DataType_Hotkey = $0003;
  // Զ      //Custom barcode
  Sync_DataType_CustomBarcode = $0004;
  // Ϣ1          //Note1
  Sync_DataType_Note1 = $0005;
  // Ϣ2          //Note2
  Sync_DataType_Note2 = $0006;
  // Ϣ3          //Note3
  Sync_DataType_Note3 = $0007;
  // Ϣ4          //Note4
  Sync_DataType_Note4 = $0008;
  //          //advertising slogan
  Sync_DataType_Advertisement = $000B;
  // ϵͳ       //system parameters
  Sync_DataType_SystemOptions = $000C;
  // ʱ          // time
  Sync_DataType_Time = $000D;
  // Ա        //operator
  Sync_DataType_Operator = $000E;
  // wifi
  Sync_DataType_Wifi = $000F;
  // ˮ ֧ϴɾ֧
  // The journal supports uploading and deleting, but does not support downloading
  Sync_DataType_UPDeleteWaterRecord = $0011;

  // C-K1   //download C-K1 parameter
  Sync_CK1_Parameter = $0013;
  // C-K1ȼ  //download C-K1 hotkey
  Sync_CK1_HotKey = $0014;

  // STTPLog
  Sync_DataType_STTPLog = $0015;
  // ChangePriceLog
  Sync_DataType_ChangePriceLog = $0016;

  // Weight
  Sync_DataType_ScaleWeight = $0017;

  // NewChangePriceLog
  Sync_DataType_NewChangePriceLog = $0018;
  // UpLogFileZip
  Sync_DataType_UpLogFileZip = $0019;

  // ϴļ λݿ  //Upload files to the lower computer database
  Sync_DataType_UpDBFile = $001B;

  // ϴָLFCodeƷ   //Upload specified LFCode Product information
  Sync_DataType_OnePLU = $001C;

  // ֿ         //font library
  Sync_DataType_Font = $1000;
  // λ //Main program of lower computer
  Sync_DataType_Firmware = $1001;
  // ADģ    //AD module
  Sync_DataType_ADModule = $1002;
  // ӡģ   //Printing module
  Sync_DataType_PrinterModule = $1003;

  // ǩԪ  //Label components
  Sync_DataType_Label = $2000;
  // ǩ   //Tag back pattern
  Sync_DataType_LabelBackGround = $2001;
  // ǩļ  //label file
  Sync_DataType_LabelFile = $2002;

  // ѹļ //Download compressed files
  Sync_DataType_ZipFile = $3000;
  // CK1ȼ    // CK1 Hot keys
  Sync_DataType_CK1_Hotkey = $3001;
  // CK1ĳ   //download CK1 The program
  Sync_DataType_CK1_Program = $3002;
  //سӲ //Sync_DataType_TouchParamSetting
  Sync_DataType_TouchParamSetting = $3003;
  //ϴشسȼ     //Upload and download touch scale hotkeys
  Sync_DataType_TouchScaleHotKeySetting = $3004;

// Ϣ // Error Information
  // ִгɹ // Execution Successful
  SDK_Err_Success = $0;
  // ¼ // Progress Event
  SDK_Err_Progress = $1;
  // ֶֹͣ // Manual Stop
  SDK_Err_Terminate = $2;

  // Ϣ // Error Information
  // ֵ֧Э // Unsupported Protocol Type
  SDK_Err_ProtocolTypeNotSupport = $100;
  // ֵ֧ // Unsupported Data Type
  SDK_Err_DataTypeNotSupport = $101;
  // ޷ļ // Cannot Open Input File
  SDK_Err_CannotOpenInputFile = $102;
  // ֶƥ // Field Count Mismatch Content Count
  SDK_Err_ImportDataFailed = $103;
  // ͨѶ쳣 // Communication Data Exception
  SDK_Err_CommDataFailed = $104;
  // 쳣 // Parse Data Exception
  SDK_Err_ParseDataFailed = $105;
  // ޷ļ // Cannot Create Output File
  SDK_Err_CannotCreateOutputFile = $106;
  // ͨParamֵ󳬹 // Param Value Error Exceeded Limit
  SDK_Err_ParamError = $107;
  // ޷ // Cannot Connect
  SDK_Err_CannotConnect = $108;

  // ûд // Command Not Found
  SDK_Err_NotHaveThisCommand = $109;
  // ݳ // Data Out of Range
  SDK_Err_DataOutOfRange = $10A;
  // дʧ // Write Error
  SDK_Err_WriteError = $10B;
  // ʣռ䲻 // Disk Space Insufficient
  SDK_Err_DiskNotEnough = $10C;
  // ȡʧ // Read Error
  SDK_Err_ReadError = $10D;
  // Ŵ // Package Number Error
  SDK_Err_PackageNoError = $10E;
  //  // Command Error
  SDK_Err_CommandError = $10F;
  // ݴ // Data Error
  SDK_Err_DataError = $110;
  // ȱֽ // Paper Out
  SDK_Err_MissPaper = $111;
  // MD5Уʧ // MD5 Check Failed
  SDK_Err_MD5CheckError = $112;

  // ӦݳȲ1 // Error Response Package Length Not 1
  SDK_Err_ErrorPackageLenError = $113;
  // ӦݳȲ // Response Package Length Incorrect
  SDK_Err_PackageLenError = $114;
  // ݴ, ҲǴ // Data Error But Not Error Command
  SDK_Err_DataErrNotErrCode = $115;

  // λûд˺űǩ // Device Missing Label Number
  SDK_Err_HaveNoThisLabelNo = $116;
  // سʱMD5У鳬ʱ // MD5 Check Timeout During Download
  SDK_Err_MD5WaitTimeOut = $117;
  // ûյĻӦ // No Response From Device
  SDK_Err_DeviceNoRespond = $118;
  // ļСȷ // File Size Incorrect
  SDK_Err_FileSizeError = $119;

  // Ͳ֧ // Hotkey Type Not Supported
  SDK_Err_HotkeyTypeNotSupport = $120;
  // ļʽ // Download File Format Error
  SDK_Err_FileFormatError = $121;
  // ļ̫С // File Too Small
  SDK_Err_FileTooSmall = $122;
  // ļ̫ // File Too Large
  SDK_Err_FileTooLarge = $123;
  // ļȷ // File Name Incorrect
  SDK_Err_FileNameErr = $124;
  // ûд˴ // No Such Error Command
  SDK_Err_NoThisErrorCode = $1FF;

  // ʽ // Format
  // ʱʽ // Time Format
  SDK_DateTimeFormat = 'YYYY-MM-DD HH:mm:SS';

  // ʧ // Task Failed
  SDK_Task_Failed = THandle(-1);

  type
  //  // Task Handle
  TSDKTaskHandle = THandle;

  // 16ַֽ // 16-byte String
  TSDKBytes16 = array [0 .. 15] of Byte;
  // 7ַֽ // 7-byte String
  TSDKBytes7 = array [0 .. 6] of Byte;
  TSDKBytes17 = array [0 .. 16] of Byte;
  // 豸Ϣ // Device Information
  PSDKDeviceInfo = ^TSDKDeviceInfo;

  // ܹ256ֽ // Total 256 Bytes
  TSDKDeviceInfo = packed Record
    Addr: UInt32; // 豸IP // Device IP
    Port: UInt32; // ˿ // Port
    ProtocolType: UInt32; // Э // Protocol Type
    DeviceNo: TSDKBytes16; // 豸 // Device Number
    Version: UInt32; // λ汾 // Firmware Version
    LanguageID: UInt8; // λ // Language Type
    KeyID: UInt8; //  // Keyboard Type
    PLUStorage: UInt16; // PLUɴ洢 // PLU Storage Capacity
    Note1Storage: UInt16; // Note1ɴ洢 // Note1 Storage Capacity
    Note2Storage: UInt16; // Note2ɴ洢 // Note2 Storage Capacity
    Note3Storage: UInt16; // Note3ɴ洢 // Note3 Storage Capacity
    Note4Storage: UInt16; // Note4ɴ洢 // Note4 Storage Capacity
    BoardType: Byte; //  // Motherboard Type
    PrintEnableDate: TSDKBytes7; // ڸʽ YYYYMMDDhhmmss // Date Format YYYYMMDDhhmmss
    PrinterKm: Double; // ӡ // Print Kilometer Count
    PrinterPaperCount: UInt32; // ӡֽ // Printed Paper Count
    EthernetMode: Byte; // ̫ģʽ // Ethernet Mode
    MacAddr: TSDKBytes17; // MACַ // MAC Address
    Reserve: Array [0 .. 173] of Byte; // ֶ // Reserved Field
  End;

  /// <summary>
  /// <para>
  /// Ȼص
  /// </para>
  /// <para>
  /// nErrorCode:  //
  /// Index:ǰ
  /// Total:
  /// lpUserData:ûָ
  /// </para>
  /// </summary>
  /// <remarks>
  /// ʼִУһIndex=0, Total= Ị̇
  /// һIndex=ǰ, Total= İ. ִ
  /// һIndex=, Total= İ. ִ
  /// 쳣ErrorCodek, Index=쳣С˳
  /// </remarks>

 /// <summary>
 /// <para>
 /// Progress Callback Function
 /// </para>
 /// <para>
 /// nErrorCode: Error code  //
 /// Index: Current row
 /// Total: Total rows
 /// lpUserData: User data pointer
 /// </para>
 /// </summary>
 /// <remarks>
 /// Start execution: Send a packet with Index=0, Total=total count.
 /// Processing: Send a packet with Index=currently completed row, Total=total count. Continue execution.
 /// End: Send a packet with Index=total count, Total=total count. Continue execution.
 /// Exception: ErrorCode != 0, Index=row where exception occurred. Exit.
 /// </remarks>

  TSDKOnProgressEvent = procedure(nErrorCode, Index, Total: Cardinal;
    lpUserData: Pointer); stdcall;

function ConvertByte16ToStr(Byte16: TSDKBytes16): {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF};
function ConvertByte17ToStr(Byte17: TSDKBytes17): {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF};
function ConvertStrToByte16(Str: {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF}): TSDKBytes16;
function ConvertStrToByte17(Str: {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF}): TSDKBytes17;

implementation

function ConvertByte16ToStr(Byte16: TSDKBytes16): {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF};
var
  i: Integer;
begin
  Result := ''; //   //Without adding this sentence, it will still run incorrectly
  for i := Low(Byte16) to High(Byte16) do
    Result := Result + {$IFDEF Linux} UTF8Char {$ELSE} AnsiChar{$ENDIF}(Byte16[i]);
  Result := {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF}(Trim(String(Result)));
end;

function ConvertStrToByte16(Str: {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF}): TSDKBytes16;
var
  i: Integer;
begin
  FillChar(Result, Length(Result), 0);
  // 汾һС16Byte   //The version number must be less than 16 Byte of
  for i := 1 to Length(Str) do
    Result[i - 1] := Ord(Str[i]);
end;

function ConvertStrToByte17(Str: {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF}): TSDKBytes17;
var
  i: Integer;
begin
  FillChar(Result, Length(Result), 0);
  for i := 1 to Length(Str) do
    Result[i - 1] := Ord(Str[i]);
end;


function ConvertByte17ToStr(Byte17: TSDKBytes17): {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF};
var
  i: Integer;
begin
  Result := ''; //   ////Without adding this sentence, it will still run incorrectly
  for i := Low(Byte17) to High(Byte17) do
    Result := Result + {$IFDEF Linux} UTF8Char {$ELSE} AnsiChar{$ENDIF}(Byte17[i]);
  Result := {$IFDEF Linux} UTF8String {$ELSE} AnsiString{$ENDIF}(Trim(String(Result)));
end;

end.
