unit SyncSDKIntf;

interface

uses
  SyncSDKDefine;

const
{$IFDEF LINUX}
  LibaryName = 'SyncSDK';
{$ELSE}
  LibaryName = 'SyncSDK.dll';
{$ENDIF}

/// <summary>
/// ʼ̬
/// </summary>
/// <returns>
/// <para>
/// Trueִгɹ
/// </para>
/// </returns>

/// <summary>
/// Initializes the dynamic library
/// </summary>
/// <returns>
/// <para>
/// Returns true if the operation was successful
/// </para>
/// </returns>
function SDK_Initialize(Adjuct: Pointer = nil): Boolean; stdcall;

/// <summary>
/// ͷŶ̬
/// </summary>

/// <summary>
/// Cleans up and releases the dynamic library
/// </summary>
procedure SDK_Finalize; stdcall;

/// <summary>
/// ȡ豸Ϣ
/// </summary>
/// <param name="Addr">
/// ַ
/// </param>
/// <returns>
/// 豸Ϣ,ֵTSDKDeviceInfo.ProtocolType=0ʱʾ豸ȡʧ.
/// </returns>

/// <summary>
/// Retrieves device information
/// </summary>
/// <param name="Addr">
/// Address
/// </param>
/// <returns>
/// Device information. When the ProtocolType field of the returned TSDKDeviceInfo structure equals 0, it indicates that device information retrieval failed.
/// </returns>
function SDK_GetDeviceInfo(Addr: Cardinal): TSDKDeviceInfo; stdcall;

/// <summary>
/// ȡλб
/// </summary>
/// <param name="Addr">
/// ַ
/// </param>
/// <param name="DeviceInfos">
/// TDeviceInfosռָ롣DeviceInfos: Array [0..n] of TSDKDeviceInfo;
/// </param>
/// <param name="Count">
/// Ŀռ
/// </param>
/// <returns>
/// 豸
/// </returns>

/// <summary>
/// Retrieves the list of machines in the network segment
/// </summary>
/// <param name="Addr">
/// Address
/// </param>
/// <param name="DeviceInfos">
/// Pointer to the pre-allocated TDeviceInfos space. DeviceInfos: Array [0..n] of TSDKDeviceInfo;
/// </param>
/// <param name="Count">
/// The allocated space size (number of elements)
/// </param>
/// <returns>
/// Returns the number of devices within the network segment.
/// </returns>
function SDK_GetNetworkSectionDevicesInfo(Addr: Cardinal; DeviceInfos: Pointer;
  Count: Cardinal): Integer; stdcall;

/// <summary>
/// 
/// </summary>
/// <param name="Addr">
/// ַϢ
/// </param>
/// <param name="ProcType">
/// 
/// </param>
/// <param name="DataType">
/// 
/// </param>
/// <param name="FileName">
/// ļָ
/// </param>
/// <param name="OnProgress">
/// 
/// </param>
/// <param name="UserData">
/// û
/// </param>
/// <returns>
/// <para>
/// 豸
/// </para>
/// <para>
/// ֵ=SDK_Task_Failed=THandle(-1)ʾ񴴽ʧ
/// </para>
/// </returns>
/// <remarks>
/// <para>
/// SDK_ExecTaskAеFileNameΪAnsi Charָ
/// </para>
/// <para>
/// SDK_ExecTaskWеFileNameΪWide Charָ
/// </para>
/// <para>
/// SDK_ExecTask = SDK_ExecTaskW
/// </para>
/// </remarks>

/// <summary>
/// Processes data
/// </summary>
/// <param name="Addr">
/// Address information
/// </param>
/// <param name="ProcType">
/// Operation type
/// </param>
/// <param name="DataType">
/// Data type
/// </param>
/// <param name="FileName">
/// Filename pointer
/// </param>
/// <param name="OnProgress">
/// Progress callback
/// </param>
/// <param name="UserData">
/// User data
/// </param>
/// <returns>
/// <para>
/// Returns a device handle
/// </para>
/// <para>
/// Return value = SDK_Task_Failed = THandle(-1) indicates task creation failed
/// </para>
/// </returns>
/// <remarks>
/// <para>
/// FileName in SDK_ExecTaskA is an Ansi Char pointer
/// </para>
/// <para>
/// FileName in SDK_ExecTaskW is a Wide Char pointer
/// </para>
/// <para>
/// SDK_ExecTask = SDK_ExecTaskW
/// </para>
/// </remarks>
function SDK_ExecTaskA(Addr, ProcType, DataType: Cardinal; FileName: PAnsiChar;
  OnProgress: TSDKOnProgressEvent; UserData: Pointer): TSDKTaskHandle; stdcall;
function SDK_ExecTask(Addr, ProcType, DataType: Cardinal; FileName: PWideChar;
  OnProgress: TSDKOnProgressEvent; UserData: Pointer): TSDKTaskHandle; stdcall;
function SDK_ExecTaskW(Addr, ProcType, DataType: Cardinal; FileName: PWideChar;
  OnProgress: TSDKOnProgressEvent; UserData: Pointer): TSDKTaskHandle; stdcall;

/// <summary>
/// ȡ
/// </summary>
/// <returns>
/// ֵ
/// </returns>

/// <summary>
/// Retrieves the last error code
/// </summary>
/// <returns>
/// The error value
/// </returns>
function SDK_GetLastTaskError: Integer; stdcall;

/// <summary>
/// ֹͣ
/// </summary>
/// <param name="TaskHandle">
/// 
/// </param>
/// <remarks>
/// <para>
/// SDK_ExecTaskص TSDKTaskHandleֹͣ
/// </para>
/// <para>
/// TaskHandle=0ֹͣڽе
/// </para>
/// <para>
/// ˺ȷҪֹͣȫֹͣŷء
/// </para>
/// </remarks>

/// <summary>
/// Stops a task
/// </summary>
/// <param name="TaskHandle">
/// The task handle
/// </param>
/// <remarks>
/// <para>
/// Pass the TSDKTaskHandle returned by SDK_ExecTask to stop that specific task.
/// </para>
/// <para>
/// Pass TaskHandle=0 to stop all currently running tasks.
/// </para>
/// <para>
/// This function ensures that the task(s) to be stopped have completely terminated before it returns.
/// </para>
/// </remarks>
procedure SDK_StopTask(TaskHandle: THandle = 0); stdcall;

/// <summary>
/// ȴ
/// </summary>
/// <param name="TaskHandle">
/// 
/// </param>
/// <remarks>
/// <para>
/// SDK_ExecTaskص TSDKTaskHandleȴ
/// </para>
/// </remarks>

///
/// <summary>
/// Waits for a task to complete
/// </summary>
/// <param name="TaskHandle">
/// The task handle
/// </param>
/// <remarks>
/// <para>
/// Pass the TSDKTaskHandle returned by SDK_ExecTask to wait for the specified task to complete.
/// </para>
/// </remarks>


procedure SDK_WaitForTask(TaskHandle: THandle); stdcall;

function SDK_GetOnePLUA(Addr: Cardinal; ALFCode: Integer; FileName: PAnsiChar): Integer; stdcall;
function SDK_GetOnePLU(Addr: Cardinal; ALFCode: Integer; FileName: PWideChar): Integer; stdcall;

function SDK_GetGroupPLUA(Addr: Cardinal; InFileName: PAnsiChar; OutFileName: PAnsiChar): Integer; stdcall;
function SDK_GetGroupPLU(Addr: Cardinal; InFileName: PWideChar; OutFileName: PWideChar): Integer; stdcall;

implementation

function SDK_Initialize; external LibaryName name 'SDK_Initialize';
procedure SDK_Finalize; external LibaryName name 'SDK_Finalize';
function SDK_GetDeviceInfo; external LibaryName name 'SDK_GetDeviceInfo';
function SDK_GetNetworkSectionDevicesInfo; external LibaryName name 'SDK_GetNetworkSectionDevicesInfo';
function SDK_ExecTaskA; external LibaryName name 'SDK_ExecTaskA';
function SDK_ExecTask; external LibaryName name 'SDK_ExecTask';
function SDK_ExecTaskW; external LibaryName name 'SDK_ExecTaskW';
function SDK_GetLastTaskError; external LibaryName name 'SDK_GetLastTaskError';
procedure SDK_StopTask; external LibaryName name 'SDK_StopTask';
procedure SDK_WaitForTask; external LibaryName name 'SDK_WaitForTask';
function SDK_GetOnePLUA;external LibaryName name 'SDK_GetOnePLUA';
function SDK_GetOnePLU;external LibaryName name 'SDK_GetOnePLU';
function SDK_GetGroupPLUA;external LibaryName name 'SDK_GetGroupPLUA';
function SDK_GetGroupPLU;external LibaryName name 'SDK_GetGroupPLU';

end.
