 package opoScales;

import java.util.Arrays;
import java.util.List;

import com.sun.jna.Structure;   

public class SyncSDKDefine {

	// 操作类型定义
	// 下载 Download
	public final static int  Sync_Action_DownLoad = 0;
	// 上传 UpLoad
	public final static int  Sync_Action_UpLoad = 1;
	// 删除 Delete
	public final static int  Sync_Action_Delete = 2;
	
	// 协议类型定义_Protocol Type Define
	public final static int   SDK_ProtocolType_None = 0;
	public final static int   SDK_ProtocolType_Sttp = 1;

	// 数据类型定义  Data Type Define
	  // 无 nil
	public final static int   Sync_DataType_nil = 0xFFFF;
	  // 单品 PLU
	public final static int   Sync_DataType_PLU = 0x0000;
	  // 部门 Department
	public final static int   Sync_DataType_Department = 0x0001;
	  // 单位 Unit
	public final static int   Sync_DataType_Unit = 0x0002;
	  // 热键 Hotkey
	public final static int   Sync_DataType_Hotkey = 0x0003;
	  // 自定义条码 CustomBarcode
	public final static int   Sync_DataType_CustomBarcode = 0x0004;
	  // 信息1 Note1
	public final static int   Sync_DataType_Note1 = 0x0005;
	  // 信息2 Note2
	public final static int   Sync_DataType_Note2 = 0x0006;
	  // 信息3 Note3
	public final static int   Sync_DataType_Note3 = 0x0007;
	  // 信息4 Note4
	public final static int   Sync_DataType_Note4 = 0x0008;
	// 头信息 Header Info
	public final static int  Sync_DataType_HeaderInfo = 0x0009;
	// 尾信息 Footer Info
	public final static int  Sync_DataType_FooterInfo = 0x000A;
	  // 广告词 Advertisement
	public final static int  Sync_DataType_Advertisement = 0x000B;
	
	// 系统参数 System Options
	public final static int  Sync_DataType_SystemOptions = 0x000C;
	  // 时间 Time 
	public final static int  Sync_DataType_Time = 0x000D;
	  // 操作员 Operator
	public final static int  Sync_DataType_Operator = 0x000E;
	  // wifi
	public final static int  Sync_DataType_Wifi = 0x000F;
	// 上传删除 流水账  Delete Or Update Journal Account​
	public final static int  Sync_DataType_UPDeleteWaterRecord = 0x0011;

	  // C-K1参数 CK1 Parameter
	public final static int  Sync_CK1_Parameter = 0x0013;
	  // C-K1热键 CK1 HotKey
	public final static int  Sync_CK1_HotKey = 0x0014;

	  // STTPLog
	public final static int  Sync_DataType_STTPLog = 0x0015;

	  // Weight
	public final static int  Sync_DataType_ScaleWeight = 0x0017;

	  // New Change Price Log
	public final static int  Sync_DataType_NewChangePriceLog = 0x0018;
	  // Upload Log File Zip
	public final static int  Sync_DataType_UpLogFileZip = 0x0019;
	
	  // 上传文件 下位机的数据库 Upload  Database File From Scale
	public final static int  Sync_DataType_UpDBFile = 0x001B;

	  // 字库 Character Library,Download the font library onto the scale, such as the L1.
	public final static int  Sync_DataType_Font = 0x1000;
	  // 下位机主程序 Firmware Of Scale
	public final static int  Sync_DataType_Firmware = 0x1001;
	  // AD模块 AD Module
	public final static int  Sync_DataType_ADModule = 0x1002;
	  // 打印模块 Printer Module
	public final static int  Sync_DataType_PrinterModule = 0x1003;

	  // 标签元件 Label Format
	public final static int  Sync_DataType_Label = 0x2000;
	  // 标签背纹 Label BackGround
	public final static int  Sync_DataType_LabelBackGround = 0x2001;
	  // 标签文件 Label File
	public final static int  Sync_DataType_LabelFile = 0x2002;

	  // 下载压缩文件 Download ZipFile
	public final static int  Sync_DataType_ZipFile = 0x3000;
	  // CK1的热键  Hotkey of CK1
	public final static int  Sync_DataType_CK1_Hotkey = 0x3001;
	  // 下载CK1的程序 Program  of CK1
	public final static int  Sync_DataType_CK1_Program = 0x3002;
	public final static int  Sync_DataType_TouchParamSetting = 0x3003;
	  // 上传下载触控秤热键 Upload or Download   HotKeySetting to TouchScale
	public final static int  Sync_DataType_TouchScaleHotKeySetting = 0x3004;

	  // 错误信息 err message
	  // 执行成功 Execution Success
	public final static int  SDK_Err_Success = 0x0;
	  // 进度事件  Progress Event
	public final static int  SDK_Err_Progress = 0x1;
	  // 手动停止 Manual Stop
	public final static int  SDK_Err_Terminate = 0x2;

	  // 错误信息  err message
	  // 不支持的协议类型 Unsupported protocol types
	public final static int  SDK_Err_ProtocolTypeNotSupport = 0x100;
	  // 不支持的数据类型 Unsupported data type
	public final static int  SDK_Err_DataTypeNotSupport = 0x101;
	//  无法打开输入文件Cannot Open Input File
	public final static int  SDK_Err_CannotOpenInputFile = 0x102;
	  // 字段数与内容数不匹配  The number of fields does not match the number of attributes
	public final static int  SDK_Err_ImportDataFailed = 0x103;
	  // 通讯数据异常 Abnormal communication data
	public final static int  SDK_Err_CommDataFailed = 0x104;
	  // 解析数据异常 Abnormal parsing of data
	public final static int  SDK_Err_ParseDataFailed = 0x105;
	  // 无法创建输出文件 Unable to create output file
	public final static int  SDK_Err_CannotCreateOutputFile = 0x106;
	  // 通信参数值错误超过次数 Communication parameter value error exceeds the number of times
	public final static int  SDK_Err_ParamError = 0x107;
	  // 无法连接 Cannot Connect
	public final static int  SDK_Err_CannotConnect = 0x108;

	  // 没有此命令 There is no such command
	public final static int  SDK_Err_NotHaveThisCommand = 0x109;
	  // 数据超长  Data is too long
	public final static int  SDK_Err_DataOutOfRange = 0x10A;
	  // 写入失败 Write failed
	public final static int  SDK_Err_WriteError = 0x10B;
	  // 剩余空间不足 Insufficient remaining space
	public final static int  SDK_Err_DiskNotEnough = 0x10C;
	  // 读取失败 Read failed
	public final static int  SDK_Err_ReadError = 0x10D;
	  // 包号错误 Package number error
	public final static int  SDK_Err_PackageNoError = 0x10E;
	  // 命令错误 Command Error
	public final static int  SDK_Err_CommandError = 0x10F;
	  //  数据错误 Data Error
	public final static int  SDK_Err_DataError = 0x110;
	  // 缺纸 Miss Paper
	public final static int  SDK_Err_MissPaper = 0x111;
	  // MD5校验失败 MD5 Check Error
	public final static int  SDK_Err_MD5CheckError = 0x112;

	  // 错误应答包数据长度不是1的错误 Error response packet data length is not 1
	public final static int  SDK_Err_ErrorPackageLenError = 0x113;
	  // 应答包数据长度不对 The length of the response packet data is incorrect
	public final static int  SDK_Err_PackageLenError = 0x114;
	  // 数据错误，且不是错误命令 Data error, and not an incorrect command
	public final static int  SDK_Err_DataErrNotErrCode = 0x115;

	  // 下位机没有此号标签 The lower computer does not have this label number
	public final static int  SDK_Err_HaveNoThisLabelNo = 0x116;
	  // MD5校验超时 MD5 Check TimeOut
	public final static int  SDK_Err_MD5WaitTimeOut = 0x117;
	  // 没有收到机器的回应包 Do not received a response package from the machine
	public final static int  SDK_Err_DeviceNoRespond = 0x118;
	  // 文件大小不正确 The file size is incorrect
	public final static int  SDK_Err_FileSizeError = 0x119;

	  // 热键类型不支持 Hotkey Type Not Supported
	public final static int  SDK_Err_HotkeyTypeNotSupport = 0x120;
	  // 下载文件格式错误 Download file format error
	public final static int  SDK_Err_FileFormatError = 0x121;
	  // 文件太小 The file is too small
	public final static int  SDK_Err_FileTooSmall = 0x122;
	  // 文件太大 The file is too large.
	public final static int  SDK_Err_FileTooLarge = 0x123;
	  // 文件名不正确 filename is incorrect
	public final static int  SDK_Err_FileNameErr = 0x124;
	  // 没有此错误命令 There is no such error command
	public final static int  SDK_Err_NoThisErrorCode = 0x1FF;

	  // 格式
	  // 时间格式 time format
	public final static String  SDK_DateTimeFormat = "YYYY-MM-DD HH:mm:SS";

	  // 任务失败 Mission failed
	public final static int  SDK_Task_Failed = -1;
	
	
	//
	public static class TSDKDeviceInfo extends Structure{
		public int Addr; // 设备IP  Scale IP
		public int Port; // 端口 Port
		public int ProtocolType; // 协议类型 Protocol Type
		public byte[] DeviceNo = new byte[16]; // 设备号 Device Number 
		public	int Version; // 下位机软件版本 Scale Version
		public byte LanguageID; // 下位机语言 Language ID
		public byte KeyID; // 键盘类型 Keyboard type
		public short PLUStorage; // PLU可存储数量 PLU Storable quantity
		public short  Note1Storage; // Note1可存储数量 Note1 Storable quantity
		public short  Note2Storage; // Note2可存储数量 Note2 Storable quantity
		public short  Note3Storage; // Note3可存储数量 Note3 Storable quantity
		public short  Note4Storage; // Note4可存储数量 Note4 Storable quantity
		public byte BoardType; // 主板类型 BoardType
		public byte[] PrintEnableDate = new byte[7]; // 日期 YYYYMMDDhhmmss  datetime YYYYMMDDhhmmss
		public byte[] PrinterKm = new byte[8];  // Print kilometers
		public int PrinterPaperCount; // 打印张数 Number of prints
		public byte EthernetMode;//Ethernet connection method
		public byte[] MacAddr = new byte[17];//Mac addr
		public byte[] Reserve= new byte[174];//Reserve
		@SuppressWarnings("rawtypes")
		protected List getFieldOrder(){
			return Arrays.asList(new String[]{"Addr","Port","ProtocolType","DeviceNo","Version","LanguageID","KeyID","PLUStorage",
					"Note1Storage","Note2Storage","Note3Storage","Note4Storage","BoardType","PrintEnableDate",
					"PrinterKm","PrinterPaperCount","EthernetMode","MacAddr","Reserve"});
		}
	}
	
	// ip地址转Long类型 ip Address transfer Long type
		public static int ipToLong(String strIp) {  
			int[] ip = new int[4];  
			int position1 = strIp.indexOf(".");  
			int position2 = strIp.indexOf(".", position1 + 1);  
			int position3 = strIp.indexOf(".", position2 + 1);  
			ip[0] = Integer.parseInt(strIp.substring(0, position1));  
			ip[1] = Integer.parseInt(strIp.substring(position1 + 1, position2));  
			ip[2] = Integer.parseInt(strIp.substring(position2 + 1, position3));  
			ip[3] = Integer.parseInt(strIp.substring(position3 + 1));  

			return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];  
		}
	
	
}
