package opoScales;

import opoScales.SyncSDKDefine.TSDKDeviceInfo;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;


public interface SyncSDKIntf extends Library {
	
	SyncSDKIntf INSTANCE = (SyncSDKIntf) Native.loadLibrary(Platform.isWindows()?"SyncSDK.dll":"libSyncSDK.so", SyncSDKIntf.class);
	
	// 回调函数 Callback Function
	public interface TSDKOnProgressEvent extends Callback {
		public abstract void callback(int nErrorCode,int nIndex,int nTotal,int nUserDataCode);
	}
	
	public long SDK_UpChangePriceLogA(int ip, String filename);
	// 执行任务 Execute the task
	public long SDK_ExecTaskA(int ip, int proc, int data, String filename, TSDKOnProgressEvent onProgress, int nUserDataCode);
	// 停止任务 Stop the task
	public void SDK_StopTask(long handle);
	// 等待任务执行完毕 Wait for the task to complete
	public void SDK_WaitForTask(long handle);
	// 初始化资源 Initialize resources
	public void SDK_Initialize();
	// 释放初始化的资源 Release initialized resources
	public void SDK_Finalize();
	// 获取设备信息  Obtain device information
	public boolean SDK_GetDevicesInfo(int Addr, TSDKDeviceInfo DeviceInfo);
	// 获取一个网段内的设备 Retrieve devices within a network segment
	public int SDK_GetNetworkSectionDevicesInfo(int Addr, TSDKDeviceInfo[] DeviceInfos,int Count);
	// 获取单个商品 Get a single product
	public int SDK_GetOnePLUA(int addr, int lfcode, String filename);
	// 批量获取单个商品 Batch obtain individual products
	public int SDK_GetGroupPLUA(int addr, String infilename, String outfilename);
		
}
