package opoTest;

import opoScales.SyncSDKDefine;
import opoScales.SyncSDKDefine.TSDKDeviceInfo;
import opoScales.SyncSDKIntf;
import opoScales.SyncSDKIntf.TSDKOnProgressEvent;


public class Main {

	
	
	 static TSDKOnProgressEvent OnProgressEvent = new TSDKOnProgressEvent(){
		@Override
		public void callback(int nErrorCode,int nIndex,int nTotal,int nUserDataCode) {
			// TODO Auto-generated method stub
			System.out.println("ErrorCode:" + nErrorCode  + " nIndex:" +nIndex + " nTotal:" + nTotal + " nUserDataCode:" + nUserDataCode );
		}
	};
	
	//
	public static void main(String[] args) {
		
		System.out.println("SDK 初始化");//SDK  Initialization
		SyncSDKIntf.INSTANCE.SDK_Initialize();
		System.out.println("初始化完成");//Initialization completed
		int ip = SyncSDKDefine.ipToLong("10.2.2.45");
		System.out.println("ip:" + ip);
		
		// 设备信息 
		// Device Information
		TSDKDeviceInfo DeviceInfo = new TSDKDeviceInfo();
		boolean resok = SyncSDKIntf.INSTANCE.SDK_GetDevicesInfo(ip,DeviceInfo); 
		// ProtocolType的正确结果是：SDK_ProtocolType_Sttp = 1 说明此时设备在线，否则设备不在线
		// ProtocolType The correct result is: SDK_ProtocolType_Sttp = 1  Indicate that the device is online at this time, otherwise the device will not be online
		System.out.println("resok:" + resok + " -- ProtocolType:"+  DeviceInfo.ProtocolType);	
		
		// 网段内设备， 当IP地址是如下格式时，可搜索网段内的设备： xxx.xxx.xxx.255 
		//Devices within the network segment, when IP When the address is in the following format, devices within the network segment can be searched: xxx.xxx.xxx.255
		TSDKDeviceInfo[] DeviceInfos = new TSDKDeviceInfo[255];
		System.out.println("1");
		int netip = SyncSDKDefine.ipToLong("10.2.2.255");
		int DevCnt = SyncSDKIntf.INSTANCE.SDK_GetNetworkSectionDevicesInfo(netip,DeviceInfos,DeviceInfos.length);
		for(int i=0;i<DevCnt;i++)
		{
			System.out.printf("DeviceInfos[%d]:%d"+"\r\n",i,DeviceInfos[i].Addr);	
		}
		System.out.printf(System.getProperty("user.dir") + "\\PLU.txt");
		long res = SyncSDKIntf.INSTANCE.SDK_ExecTaskA(ip, SyncSDKDefine.SDK_ProtocolType_None,SyncSDKDefine.Sync_Action_DownLoad, System.getProperty("user.dir") + "\\PLU.txt", OnProgressEvent, 111);
		// 等待线程执行完成
		//Waiting for thread execution to complete
		SyncSDKIntf.INSTANCE.SDK_WaitForTask(res);
		
		// 上传单个商品
		//Upload a single product
		int lfcode = 10001;
		int result;
		result = SyncSDKIntf.INSTANCE.SDK_GetOnePLUA(ip, lfcode, System.getProperty("user.dir") + "\\OnePLU.txt");
		
		String infilename = System.getProperty("user.dir") + "\\InFileName.txt";
		String outfilename = System.getProperty("user.dir") + "\\GroupPLU.txt";
		result = SyncSDKIntf.INSTANCE.SDK_GetGroupPLUA(ip, infilename, outfilename);
		
		System.out.println("结束");//finish

	}
	
}
