package DLL;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;


import DLL.ScalesLib.OnCallback;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JComboBox;
import javax.swing.DefaultComboBoxModel;

public class Main extends JFrame {

	static JLabel lblWeightInfo = new JLabel("WeightInfo");
	
	static OnCallback OnModuleCall = new OnCallback(){
		@Override
		public void callback(String s,int sLength) {
			// TODO Auto-generated method stub
			lblWeightInfo.setText(s);
		}
	}; 
	
	
	
	public static String BytesToString(byte by[]) {
		String str = new String(by);
		int pos = str.indexOf('\0');
		if (pos != -1)
			str = str.substring(0, pos);
		return str;
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JPanel contentPane;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		
		DLL.ScalesLib.INSTANCE.OPO_NonFormsMode(); //java 必须调用
		DLL.ScalesLib.INSTANCE.OPO_SetModuleCallBack(OnModuleCall);		
		  
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					Main frame = new Main();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public Main() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 506, 303);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);

		
		final JComboBox<String> cbbCom = new JComboBox<String>();
		cbbCom.setModel(new DefaultComboBoxModel<String>(new String[] {"COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9"}));
		cbbCom.setSelectedIndex(0);
		cbbCom.setBounds(59, 45, 159, 21);
		contentPane.add(cbbCom);
		
		JButton btnNewButton = new JButton("Open");
		btnNewButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (DLL.ScalesLib.INSTANCE.OPO_Open(cbbCom.getSelectedItem().toString()) != 0)
					JOptionPane.showMessageDialog(null, "OK!"); 
				else
					JOptionPane.showMessageDialog(null, "Fail!");
			}
		});
		btnNewButton.setBounds(59, 76, 159, 23);
		contentPane.add(btnNewButton);

		JButton btnNewButton_1 = new JButton("GetResult");
		btnNewButton_1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				byte[] data = new byte[100];
				DLL.ScalesLib.INSTANCE.OPO_GetResult(data);
				JOptionPane.showMessageDialog(null, BytesToString(data)); 
			}
		});
		btnNewButton_1.setBounds(270, 168, 159, 23);
		contentPane.add(btnNewButton_1);

		
		lblWeightInfo.setBounds(59, 10, 322, 15);
		contentPane.add(lblWeightInfo);
		
		JButton btnClose = new JButton("Close");
		btnClose.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			if (DLL.ScalesLib.INSTANCE.OPO_Close() != 0)
				JOptionPane.showMessageDialog(null, "OK!"); 
			else
				JOptionPane.showMessageDialog(null, "Fail!");
			}
		});
		btnClose.setBounds(270, 76, 159, 23);
		contentPane.add(btnClose);
		
		JButton btnZero = new JButton("Zero");
		btnZero.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if( DLL.ScalesLib.INSTANCE.OPO_Zero() != 0)
					JOptionPane.showMessageDialog(null, "OK!"); 
				else
					JOptionPane.showMessageDialog(null, "Fail!");
			}
		});
		btnZero.setBounds(59, 168, 159, 23);
		contentPane.add(btnZero);
		
		JButton btnTare = new JButton("Tare");
		btnTare.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if( DLL.ScalesLib.INSTANCE.OPO_Tare() != 0)
					JOptionPane.showMessageDialog(null, "OK!"); 
				else
					JOptionPane.showMessageDialog(null, "Fail!");
			}
		});
		btnTare.setBounds(59, 201, 159, 23);
		contentPane.add(btnTare);
		
		JButton btnSetAutoMode = new JButton("SetAutoMode");
		btnSetAutoMode.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if( DLL.ScalesLib.INSTANCE.OPO_SetAutoMode() != 0)
					JOptionPane.showMessageDialog(null, "OK!"); 
				else
					JOptionPane.showMessageDialog(null, "Fail!");
				
			}
		});
		btnSetAutoMode.setBounds(59, 122, 370, 23);
		contentPane.add(btnSetAutoMode);

	}
}
