﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ScalesSDKDemo
{
    public partial class Form1 : Form
    {

        const string dllname = "ScalesSDK.dll";

        public static OnCallBack OnOPOModule;

        public delegate void OnCallBack(String sResult, int sResultLength);



        [DllImport(dllname)]// OP回调
        public static extern int OPO_SetModuleCallBack(OnCallBack OnOPOMoudle);

        [DllImport(dllname)]// 主动上传模式
        public static extern int OPO_SetAutoMode();


        [DllImport(dllname)]// 
        public static extern int OPO_Open(string sConnect);

        [DllImport(dllname)]
        public static extern int OPO_Close();

        [DllImport(dllname)]//重新获取重量信息
        public static extern int OPO_GetResult(StringBuilder sWeight);

        [DllImport(dllname)]//读取缓存区重量(主动上传模式)
        public static extern int OPO_AngleGetResult(StringBuilder sWeight);

        [DllImport(dllname)]//设置上传频率 0~10
        public static extern int OPO_SendFre(int Value);

        [DllImport(dllname)]// 归零命令
        public static extern int OPO_Zero();

        [DllImport(dllname)]// 去皮
        public static extern int OPO_Tare();

        [DllImport(dllname)]// 预制去皮命令
        public static extern int OPO_PreTare(int Value);

        [DllImport(dllname)]// 改变称重单位
        public static extern int OPO_SetUnit(int Value);

		[DllImport(dllname)]// 强制开机归零点
        public static extern int OPO_PowOnZero();

        public Form1()
        {
            InitializeComponent();
        }


        private void btnResult_Click(object sender, EventArgs e)
        {
            StringBuilder sWeight = new StringBuilder(100);
            if (OPO_GetResult(sWeight) != 0)
                MessageBox.Show(sWeight.ToString());
            else MessageBox.Show("Fail!");
        }


        public void OnOPBoxCallBack(string sCallBack,int sCallBackLength)
        {
            lblOPBox.Text = sCallBack;

        }

        private void Form1_Load(object sender, EventArgs e)
        {

            OnOPOModule = new OnCallBack(OnOPBoxCallBack);
            OPO_SetModuleCallBack(OnOPOModule);
        }

        private void btnAutoMode_Click(object sender, EventArgs e)
        {
            if (OPO_SetAutoMode() == 1)
                MessageBox.Show("OK");
            else MessageBox.Show("Fail!");
        }

        private void btnZero_Click(object sender, EventArgs e)
        {
            if (OPO_Zero() == 1)
                MessageBox.Show("OK");
            else MessageBox.Show("Fail!");
        }

        private void btnTare_Click(object sender, EventArgs e)
        {
            if (OPO_Tare() == 1)
                MessageBox.Show("OK");
            else MessageBox.Show("Fail!");
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            if (OPO_Open(cbbCOM.Text + ":" + cbbRate.Text) != 0)
                MessageBox.Show("OK");
            else MessageBox.Show("Fail!");
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            OPO_Close();
        }
    }
}
