#include "StdAfx.h"
#include "ScalesLib.h"



HINSTANCE							pHinstance = NULL;

pSetModuleCallBack					OPO_SetModuleCallBack = NULL;
pSetAutoMode						OPO_SetAutoMode = NULL;
pOpen								OPO_Open = NULL;
pClose								OPO_Close = NULL;
pGetResult							OPO_GetResult = NULL;
pReadResultCache					OPO_ReadResultCache = NULL;
pSendFre							OPO_SendFre = NULL;
pZero								OPO_Zero = NULL;
pTare								OPO_Tare = NULL;
pPreTare							OPO_PreTare = NULL;
pSetUnit							OPO_SetUnit = NULL;
pPowOnZero							OPO_PowOnZero = NULL;


//DLL
bool OPO_LoadDll()
{
	if (pHinstance != NULL)	return true;
	pHinstance = LoadLibraryA("ScalesSDK.dll");
	if (pHinstance == NULL)
	{
		return FALSE;
	}
	OPO_SetModuleCallBack = (pSetModuleCallBack)GetProcAddress(pHinstance, "OPO_SetModuleCallBack");
	if (NULL == OPO_SetModuleCallBack)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_SetAutoMode = (pSetAutoMode)GetProcAddress(pHinstance, "OPO_SetAutoMode");
	if (NULL == OPO_SetAutoMode)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_Open = (pOpen)GetProcAddress(pHinstance, "OPO_Open");
	if (NULL == OPO_Open)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_Close = (pClose)GetProcAddress(pHinstance, "OPO_Close");
	if (NULL == OPO_Close)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_GetResult = (pGetResult)GetProcAddress(pHinstance, "OPO_GetResult");
	if (NULL == OPO_GetResult)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_ReadResultCache = (pReadResultCache)GetProcAddress(pHinstance, "OPO_ReadResultCache");
	if (NULL == OPO_ReadResultCache)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_SendFre = (pSendFre)GetProcAddress(pHinstance, "OPO_SendFre");
	if (NULL == OPO_SendFre)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_Zero = (pZero)GetProcAddress(pHinstance, "OPO_Zero");
	if (NULL == OPO_Zero)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_Tare = (pTare)GetProcAddress(pHinstance, "OPO_Tare");
	if (NULL == OPO_Tare)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_PreTare = (pPreTare)GetProcAddress(pHinstance, "OPO_PreTare");
	if (NULL == OPO_PreTare)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_SetUnit = (pSetUnit)GetProcAddress(pHinstance, "OPO_SetUnit");
	if (NULL == OPO_SetUnit)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	OPO_PowOnZero = (pPowOnZero)GetProcAddress(pHinstance, "OPO_PowOnZero");
	if (NULL == OPO_PowOnZero)
	{
		FreeLibrary(pHinstance);
		return FALSE;
	}

	return true;
}

//жDLL
void OPO_UnloadDll()
{
	if (pHinstance != NULL)
	{
		OPO_SetModuleCallBack = NULL;
		OPO_SetAutoMode = NULL;
		OPO_Open = NULL;
		OPO_Close = NULL;
		OPO_GetResult = NULL;
		OPO_ReadResultCache = NULL;
		OPO_SendFre = NULL;
		OPO_Zero = NULL;
		OPO_Tare = NULL;
		OPO_PreTare = NULL;
		OPO_SetUnit = NULL;
		OPO_PowOnZero = NULL;
		FreeLibrary(pHinstance);
		pHinstance = NULL;
	}
}