unit uMain;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls,  printers;

const
  sScalesLibName = 'ScalesSDK.dll';

  // ص
Procedure OnOPOModule(sModuleInfo: PAnsiChar; sLength: Integer); Stdcall;

// ûص
procedure OPO_SetModuleCallBack(OnCallBack: Pointer); stdcall; external sScalesLibName;

// ϴģʽ
function OPO_SetAutoMode: Integer; stdcall; external sScalesLibName;

// ͨѶ
function OPO_Open(sConnect: PAnsiChar): Integer; stdcall; external sScalesLibName;

// ر
function OPO_Close: Integer; stdcall; external sScalesLibName;

// ȡ
function OPO_GetResult(sWeight: PAnsiChar): Integer; stdcall; external sScalesLibName;

// ȡ
function OPO_ReadResultCache(sWeight: PAnsiChar): Integer; stdcall; external sScalesLibName;

// 
function OPO_Zero: Integer; stdcall; external sScalesLibName;

// ȥƤ
function OPO_Tare: Integer; stdcall; external sScalesLibName;

// ǿƿ
function OPO_PowOnZero; stdcall; external sScalesLibName;

type
  TfrmMain = class(TForm)
    cbbComName: TComboBox;
    cbbComRate: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    btnComOpen: TButton;
    btnComClose: TButton;
    btnProtocol: TButton;
    Label3: TLabel;
    lblOPWeight: TLabel;
    btnGetResult: TButton;
    Button1: TButton;
    procedure btnComOpenClick(Sender: TObject);
    procedure btnComCloseClick(Sender: TObject);
    procedure btnProtocolClick(Sender: TObject);
    procedure btnGetResultClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

Procedure OnOPOModule(sModuleInfo: PAnsiChar; sLength: Integer); Stdcall;
begin
  frmMain.lblOPWeight.Caption := string(sModuleInfo);
end;

procedure TfrmMain.btnComCloseClick(Sender: TObject);
begin
  OPO_Close;
end;

procedure TfrmMain.btnComOpenClick(Sender: TObject);
begin

  if OPO_Open(PAnsiChar(AnsiString(Format('%s:%s', [cbbComName.Text, cbbComRate.Text]))))
    = Integer(true) then
  begin
    //OPO_SetAutoMode;
    ShowMessage('Open Com OK!')
  end
  else
    ShowMessage('Open Com Fail!')

end;

procedure TfrmMain.btnGetResultClick(Sender: TObject);
var
  s: array [0 .. 100] of Char;
begin
  if OPO_GetResult(@s[0]) = Integer(true) then
    ShowMessage('GetResult: ' + string(PAnsiChar(@s[0])))
  else
    ShowMessage('GetResult: Fail!');
end;

procedure TfrmMain.btnProtocolClick(Sender: TObject);
begin
  if OPO_SetAutoMode = Integer(true) then
    Application.MessageBox('OK!', 'ʾ', 0)
  else
    Application.MessageBox('Fail!', 'ʾ', 0)
end;

procedure TfrmMain.Button1Click(Sender: TObject);
var
  s: array [0 .. 100] of Char;
begin
  if OPO_ReadResultCache(@s[0]) = Integer(true) then
    ShowMessage('ReadResultCache: ' + string(PAnsiChar(@s[0])))
  else
    ShowMessage('ReadResultCache: Fail!');

end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  OPO_SetModuleCallBack(@OnOPOModule);
end;

end.
